/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package examples;

import java.nio.file.Path;
import java.nio.file.Paths;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class NavigationalPathMethods {
    public static void main(String[] args) {
        System.out.println("Absolute Path:");
        Path absolutePath = Paths.get(
            "C:\\Users\\Matt\\Desktop\\Courses\\DWT\\Java Courses\\Advanced Java Programming\\Projects\\Chapter5 - Working with Files");
        System.out.println(absolutePath);
        System.out.println("Relative Path:");
        Path relativePath = Paths.get("..\\Chapter4 - Introducing IO");
        System.out.println(relativePath);
        System.out.println("");
        System.out.println("Resolve the absolute path against the relative path:");
        System.out.println(absolutePath.resolve(relativePath));
        System.out.println("Normalise this result:");
        System.out.println(absolutePath.resolve(relativePath).normalize());
        System.out.println("");
        System.out.println("Subpath (0,7) of the absolute path:");
        System.out.println(absolutePath.subpath(0,7));
        System.out.println("Name Count of absolute path:");
        System.out.println(absolutePath.getNameCount());
        System.out.println("The 3rd Name in the absolute path:");
        System.out.println(absolutePath.getName(2));
        System.out.println("");
        System.out.println ("Resolve");
        Path destination = Paths.get(
            "C:\\Users\\Matt\\Desktop\\Courses\\DWT\\Java Courses"
            + "\\Advanced Java Programming\\Projects\\"
            + "Chapter10 - Connecting to a Database with JDBC\\database scripts");
        System.out.println("How do I get from:");
        System.out.println(absolutePath);
        System.out.println("to:");
        System.out.println(destination);
        System.out.println("Use relativise:");
        System.out.println(absolutePath.relativize(destination));
        System.out.println("And back again?");
        System.out.println(destination.relativize(absolutePath));
        System.out.println("");
    }
}
